<?php include '3111header.php'; ?>

<div id="menu">
<?php include '3111menu.php'; ?>
</div> <!--End Menu-->

<div id="more">
	<h3>Getting hddtemp</h3>
	<ul class="disc">
		<li><a href="http://search.cpan.org/~yorhel/Linux-hddtemp/">Latest Version</a></li>
		<li><a href="http://www.guzu.net/linux/hddtemp.php">hddtemp homepage</a></li>
	</ul>
	<h3>References</h3>
	<ul class="disc">
		<li><a href="http://labs.google.com/papers/disk_failures.html">Google Labs</a></li>
		<li><a href="http://www.usenix.org/event/fast07/">USENIX Conference</a></li>
	</ul>
</div>
<div id="content">
	<h2>hddtemp - hot drives die early</h2>
	<p>
	Context text here.&nbsp hddtemp prints the temperature for each specified hard drive in degrees Celsius.&nbsp The hard drive must support S.M.A.R.T.&nbsp Just about all hard drives sold in the past 5 years do. </p>

<h3>Usage:</h3>

	<pre>hddtemp device [,device2, ...]</pre>

<p>Examples:</p>

	<pre>hddtemp /dev/sda</pre>

    <p>or for all drives:</p>

	<pre>
hddtemp $(for i in $(cat /proc/partitions | \
egrep sd[abcdefgh]$ | sed -e 's/^.*s/s/'); do \
echo -n "/dev/$i "; done)
</pre>

    <p>or using multiple hddtemp calls:</p>

	<pre>for i in $(cat /proc/partitions | egrep sd[abcdefgh]$ | \
sed -e 's/^.*s/s/'); do hddtemp /dev/$i</pre>

<h3>Note:</h3>

	<p>Heat is the arch enemy of hard drives. Increasing hard drive temperatures by 5°C has the same effect on reliability as switching from 10% to 100% drive workload. Each one-degree drop of HDD temperature is equivalent to a 10% increase of service life. Temperature readings should not exceed 47 degrees to insure maximum service life. If your temps do exceed 47 degrees, then consider changing the drive location within the case or adding a fan to provide additional air flow that will increase heat dissipation.</p>

	<p>The optimum S.M.A.R.T.-reported temperature range of 36 °C to 47 °C. [see ref.] Manufacturer acceptable ranges are generally between 10 and 55.</p>

<p>"Failure Trends in a Large Disk Drive Population"[1] in 5th USENIX Conference on File and Storage Technologies (FAST 2007)[2]. USENIX Conference on File and Storage Technologies.</p>

	<ul style="list-style-type: none">
	<li>[1]  <a href="http://labs.google.com/papers/disk_failures.html"> http://labs.google.com/papers/disk_failures.html</a></li>
	<li>[2]  <a href="http://www.usenix.org/event/fast07/">http://www.usenix.org/event/fast07/</a></li>
	</ul>
</div>

<?php include '3111cleardiv.php'; ?>

</div> <!--End container2-->

</div> <!--End container-->

<?php include '3111footer.php'; ?>