<?php include '3111header.php'; ?>

<div id="menu">
<?php include '3111menu.php'; ?>
</div>

<div id="more">
	<h3>More Resouces</h3>
	<ul class="disc">
	<li><a href="http://www.w3schools.com/css/css_reference.asp" target="_blank">CSS2 Reference</a></li>
	<li><a href="http://www.w3schools.com/sitemap.asp">w3schools Sitemap</a></li>
	<li><a href="http://www.w3schools.com/site/site_validate.asp">Site Validation</a></li>
	</ul>
	<h3>more Title</h3>
	<p>more Content</p>
</div>
<div id="content">
<h2>CSS Syntax</h2>
<h3>Syntax</h3>
<p>The CSS syntax is made up of three parts: a selector, a property and a value:</p>
<pre>selector {property: value}</pre>
<p>The selector is normally the HTML element/tag you wish to define, the property is the attribute you wish to change, and each property can take a value. The property and value are separated by a colon, and surrounded by curly braces:</p>
<pre>body {color: black}</pre>
<p>Note: If  the value is multiple words, put quotes around the value:</p>
<pre>p {font-family: "sans serif"}</pre>
<p>Note: If you wish to specify more than one property, you must separate each property with a semicolon. The example below shows how to define a center aligned paragraph, with a red text color:</p>
<pre>p {text-align:center;color:red}</pre>
<p>To make the style definitions more readable, you can describe one property on each line, like this:</pre>
<pre>
p
{
text-align: center;
color: black;
font-family: arial
}
</pre>
<h3>Grouping</h3>
<p>You can group selectors. Separate each selector with a comma. In the example below we have grouped all the header elements. All header elements will be displayed in green text color:</p>
<pre>h1,h2,h3,h4,h5,h6
{
color: green
}
</pre>
<h3>The class Selector</h3>
<p>With the class selector you can define different styles for the same type of HTML element.</p>
<p>Say that you would like to have two types of paragraphs in your document: one right-aligned paragraph, and one center-aligned paragraph. Here is how you can do it with styles:</p>
<pre>
p.right {text-align: right}
p.center {text-align: center}
</pre>
<p>You have to use the class attribute in your HTML document:</p>
<pre>
&lt;p class="right"&gt;
This paragraph will be right-aligned.
&lt;/p&gt;

&lt;p class="center"&gt;
This paragraph will be center-aligned.
&lt;/p&gt;
</pre>
<p>Note: To apply more than one class per given element, the syntax is:</p>
<pre>
&lt;p class="center bold"&gt;
This is a paragraph.
&lt;/p&gt;
</pre>
<p>The paragraph above will be styled by the class "center" AND the class "bold".</p>
<p>You can also omit the tag name in the selector to define a style that will be used by all HTML elements that have a certain class. In the example below, all HTML elements with class="center" will be center-aligned:</p>
<pre>
.center {text-align: center}
</pre>
<p>In the code below both the h1 element and the p element have class="center". This means that both elements will follow the rules in the ".center" selector:</p>
<pre>
&lt;h1 class="center"&gt;
This heading will be center-aligned
&lt;/h1&gt;

&lt;p class="center"&gt;
This paragraph will also be center-aligned.
&lt;/p&gt;
</pre>
<p><u>Remark:</u> Do NOT start a class name with a number! It will not work in Mozilla/Firefox.</p>
<p>Add Styles to Elements with Particular Attributes</p>
<p>You can also apply styles to HTML elements with particular attributes.</p>
<p>The style rule below will match all input elements that have a type attribute with a value of "text":</p>
<pre>
input[type="text"] {background-color: blue}
</pre>

<h3>The id Selector</h3>

<p>You can also define styles for HTML elements with the id selector. The id selector is defined as a #.</p>

<p>The style rule below will match the element that has an id attribute with a value of "green":</p>
<pre>
#green {color: green}
</pre>
<p>The style rule below will match the p element that has an id with a value of "para1":</p>
<pre>
p#para1
{
text-align: center;
color: red
}
</pre>

<p><u>Remark:</u> Do NOT start an ID name with a number! It will not work in Mozilla/Firefox.</p>

<h3>CSS Comments</h3>

<p>Comments are used to explain your code, and may help you when you edit the source code at a later date. A comment will be ignored by browsers. A CSS comment begins with "/*", and ends with "*/", like this:</p>
<pre>
/* This is a comment */
p
{
text-align: center;
/* This is another comment */
color: black;
font-family: arial
}
</pre>
<!-- <a href="popupbasic.html" onClick="return popup(this, 'notes')">my popup</a> -->
</div>
<div id="cleardiv">
<!-- <div id="cleardiv_lt"> -->
<div id="cleardiv_rt">
	<a href="http://jigsaw.w3.org/css-validator/"><img style="width: 85px; height:28px; float: right;" src="http://jigsaw.w3.org/css-validator/images/vcss-blue" alt="Valid CSS!" />
	</a>
	<a href="http://validator.w3.org/check?uri=referer"><img style="width: 85px; height:28px; padding-left: 0; float: right;" src="http://www.w3.org/Icons/valid-html401-blue" alt="Valid HTML 4.01 Strict">
	</a>
</div> <!--End cleardiv_rt-->
<!--</div>--> <!--End cleardiv_lt-->
</div> <!--End cleardiv-->
</div>
</div>
<?php include '3111footer.php'; ?>