<?php include '3111header.php'; ?>

<div id="menu">
<?php include '3111menu.php'; ?>
</div> <!--End Menu-->

<div id="more">
	<h3>More Resources</h3>
	<p>A fairly complete directory listing of what the /tmp/modular build environment will look like for the compiling X and building the Intel linux graphic driver</p>
	<ul class="disc">
		<li><a href="http://3111skyline.com/download/linux/xwindows/BuildingX.bz2">Build Environment</a></li>
	</ul>
</div>
<div id="content">
	<h2 style="line-height: 120%">Compiling X and Building the<br>Intel Linux Graphic Drivers</h2>
	<h3>Background Information</h3>
	<p>During April 2007, on SuSE 10.0, I was faced with the problem of having to rebuild the Intel linux graphics driver to support a new monitor I purchased that needed 1680x1050 resolution. The old solutions of creating a fake resolution mode patch with 815/915resolution would not work so I decided to try and build the driver. After much searching and many posts to both the kernel and xfree86 mailing lists, I stumbled upon the links that held the key to being able to put all the pieces together to build a new X-Windows system and then build the Intel linux graphics driver module I needed. (including using mesa and drm)</p>
	<p>Note, it has been more than a year and a half since I did this, so I am no expert on the subject, but due to the unexpected number of requests for help I have received over the past year, I have put this small page together to provide the links and as much information as I can remember. Building everything is not that hard, but you will of course need the linux c compiler gcc and all the needed source packages and libraries installed.</p>
	<h3>An Overview of What is Required</h3>
	<p>The difficult part is understanding what it is you are doing from an overview perspective. You are not simply compiling the code for the driver, you are compiling an entire new X-Windows system to provide the files needed to build the Intel linux graphics driver against so that you gain the needed capabilities that brought you here in the first place. If you are familiar with building kernel modules, that is fairly analogous to what you are doing here. Just as you need the kernel source installed and 'prepared' to build a kernel module against, you need a proper X-Windows installed and prepared before you can build the Intel linux graphics driver (module) against to accommodate your new hardware needs. That is also why you can't simply make due with the fake resolution mode work-around, you don't have the X-Window system that will support your present hardware. (otherwise, what in the heck would you be doing here?)</p>
	<h3>How To Do It - The Most Important Part</h3>
	<p>The links below will provide you with a step-by-step walkthrough on how to get everything installed and set up so that you can compile the driver, but you have to <strong>SLOW DOWN</strong> and <strong>READ THE DOCUMENTATION</strong> that the links provide <strong>VERY CAREFULLY.</strong> After pulling my hair out and probably more than a dozen posts to the various lists, I finally realized that the links provided all of the information required, but it isn't that clear the first time you read it. (or at least it wasn't to me) You really do have to read and follow the documentation <strong>WORD-FOR-WORD.</strong> Once I had all the pieces in the right place, the compile ran without any problems and left me with a 100% functional X-Windows setup with a perfect 1680x1050 display. Alright, enough background, here are the links:</p>
	<h3>4 Pieces to the Intel Linux Graphics Driver Puzzle</h3>
	<ul class="disc">
		<li><a href="http://intellinuxgraphics.org/install.html">Intel Linux Graphics Driver Installation Guide</a></li>
		<li style="padding-top: 7px;"><a href="http://intellinuxgraphics.org/download.html">Source Code: xf86-video-Intel, drm, mesa</a></li>
		<li style="padding-top: 7px;"><a href="http://wiki.x.org/wiki/ModularDevelopersGuide">The X.Org Modular Tree Developer's Guide</a></li>
		<li style="padding-top: 7px;"><a href="http://wiki.x.org/wiki/Development/git">Modular X development using the git trees</a></li>
	</ul>
	<h3>Afer You Successfully Compile The Driver</h3>
	<p>After you have compiled X-Windows and the new xf86-video-Intel module you have two option for how you will permanently run the new X-Window environment. You can either completely replace your current X-Windows system with the new modular tree that you used to compile everything, or you can simply tell X to start in the new build environment instead of using the old one. (that's what I did). All that is required for the second case it to pass an additional command line switch to startx so that it uses the new build. I just put the command line in a bash script and was done. If you followed the directions in the links above, your new X-Windows probably resides under the /tmp/modular directory that you used to compile everything. The command line switch for startx is simply:</p>
	<pre>startx -- /tmp/modular/bin/Xorg</pre>
	<p>If you want to take a look at what the build environment will look like for the compile, I dumped a crude directory tree showing the directory and file layout for /tmp/modular that may help you get the pieces in the right places. Note: most of the files show in the listing were produced during the build, but the directory structure itself will tell you if you are heading in the right direction. The listing is contained in a bzip2 file for download. Just click on the "Build Environment" link at the top right of the page. Good Luck.</p>
</div> <!--End content div-->

<?php include '3111cleardiv.php'; ?>

</div> <!--End container2-->

</div> <!--End container-->

<?php include '3111footer.php'; ?>